/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipe
implements ICustomOutputRecipe<IAlloyTank> {
    private final class_2960 id;
    private final List<FluidIngredient> inputs;
    private final FluidStack output;
    private final int temperature;
    private List<List<FluidStack>> displayInputs;

    public List<List<FluidStack>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = this.inputs.stream().map(FluidIngredient::getFluids).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    private static BitSet makeBitset(IAlloyTank inv) {
        int tanks = inv.getTanks();
        BitSet used = new BitSet(tanks);
        for (int i = 0; i < tanks; ++i) {
            if (!inv.getFluidInTank(i).isEmpty()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(FluidIngredient ingredient, IAlloyTank inv, BitSet used, boolean checkSize) {
        for (int i = 0; i < inv.getTanks(); ++i) {
            if (used.get(i)) continue;
            FluidStack fluid = inv.getFluidInTank(i);
            if (!(checkSize ? ingredient.test(fluid) : ingredient.test(fluid.getFluid()))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public boolean matches(IAlloyTank inv, class_1937 worldIn) {
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, false);
            if (index != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canPerform(IAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return false;
        }
        BitSet used = AlloyRecipe.makeBitset(inv);
        int drainAmount = 0;
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1) {
                FluidStack fluid = inv.getFluidInTank(index);
                drainAmount = (int)((long)drainAmount + ingredient.getAmount(fluid.getFluid()));
                continue;
            }
            return false;
        }
        return inv.canFit(this.output, drainAmount);
    }

    public void performRecipe(IMutableAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return;
        }
        FluidStack[] drainFluids = new FluidStack[inv.getTanks()];
        int drainAmount = 0;
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1 && drainFluids[index] == null) {
                FluidStack fluid = inv.getFluidInTank(index);
                long amount = ingredient.getAmount(fluid.getFluid());
                drainAmount = (int)((long)drainAmount + amount);
                drainFluids[index] = new FluidStack(fluid, amount);
                continue;
            }
            return;
        }
        if (inv.canFit(this.output, drainAmount)) {
            for (int i = 0; i < drainFluids.length; ++i) {
                FluidStack drained;
                FluidStack toDrain = drainFluids[i];
                if (toDrain == null || (drained = inv.drain(i, toDrain)).getAmount() == toDrain.getAmount()) continue;
                TConstruct.LOG.error("Wrong amount of fluid {} drained for recipe {}", (Object)drained.getFluid(), (Object)this.id);
            }
            long filled = inv.fill(this.output.copy());
            if (filled != this.output.getAmount()) {
                TConstruct.LOG.error("Filled only {} for recipe {}", (Object)filled, (Object)this.id);
            }
        }
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.ALLOYING.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.alloyingSerializer.get();
    }

    public AlloyRecipe(class_2960 id, List<FluidIngredient> inputs, FluidStack output, int temperature) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.temperature = temperature;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<AlloyRecipe> {
        public AlloyRecipe fromJson(class_2960 id, JsonObject json) {
            FluidStack result = RecipeHelper.deserializeFluidStack(class_3518.method_15296((JsonObject)json, (String)"result"));
            List<FluidIngredient> inputs = JsonHelper.parseList(json, "inputs", FluidIngredient::deserialize);
            if (inputs.size() < 2) {
                throw new JsonSyntaxException("Too few inputs to alloy recipe " + id);
            }
            for (FluidIngredient input : inputs) {
                if (!input.test(result)) continue;
                throw new JsonSyntaxException("Result fluid contained in input in alloy recipe " + id);
            }
            int temperature = class_3518.method_15260((JsonObject)json, (String)"temperature");
            return new AlloyRecipe(id, inputs, result, temperature);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, AlloyRecipe recipe) {
            recipe.output.writeToPacket(buffer);
            buffer.method_10804(recipe.inputs.size());
            for (FluidIngredient input : recipe.inputs) {
                input.write(buffer);
            }
            buffer.method_10804(recipe.temperature);
        }

        @Override
        @Nullable
        protected AlloyRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            FluidStack output = FluidStack.readFromPacket((class_2540)buffer);
            int inputCount = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inputCount; ++i) {
                builder.add((Object)FluidIngredient.read(buffer));
            }
            int temperature = buffer.method_10816();
            return new AlloyRecipe(id, (List<FluidIngredient>)builder.build(), output, temperature);
        }
    }
}

